-- create toloka task suites
INSERT INTO toloka_mgr.toloka_task_suite (id, toloka_id, toloka_pool_id, overlap, created_at, solved_at)
VALUES
(1, 'fca8ee8d-78f2-47bf-9738-a6620da4b021', 1000, 3, '2017-01-01 09:00:00', null),
(2, 'fca8ee8d-78f2-47bf-9738-a6620da4b022', 1000, 3, '2017-01-01 09:00:00', null),
(3, 'fca8ee8d-78f2-47bf-9738-a6620da4b023', 1001, 3, '2017-01-01 09:00:00', null),
(4, 'fca8ee8d-78f2-47bf-9738-a6620da4b024', 1002, 3, '2017-01-02 09:00:00', '2017-01-02 12:00:00'),
(5, 'fca8ee8d-78f2-47bf-9738-a6620da4b025', 1003, 3, '2017-01-02 09:00:00', '2017-01-02 12:00:00'),
(6, 'fca8ee8d-78f2-47bf-9738-a6620da4b026', 1004, 3, '2017-01-13 09:00:00', '2017-01-13 12:00:00'),
(7, 'fca8ee8d-78f2-47bf-9738-a6620da4b027', 1005, 3, '2017-01-03 09:00:00', '2017-01-03 12:00:00'),
(20, 'fca8ee8d-78f2-47bf-9738-a6620da4b028', 1006, 3, '2017-01-23 09:00:00', null),
(21, 'fca8ee8d-78f2-47bf-9738-a6620da4b029', 1007, 3, '2017-01-24 09:00:00', null);

SELECT setval('toloka_mgr.toloka_task_suite_id_seq', 100);

INSERT INTO toloka_mgr.task_type_info (type_id)
                VALUES (3), (4);

-- create tasks
INSERT INTO toloka_mgr.task (id, txn_id, type_id, status, input_values, output_values, overlap, created_at, posted_at, solved_at, known_solutions, message_on_unknown_solution)
VALUES (1, 0, 3, 'new', '{"input": 1}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (2, 0, 3, 'new', '{"input": 2}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (3, 0, 4, 'new', '{"input": 3}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (4, 0, 4, 'new', '{"input": 4}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (5, 0, 3, 'in-progress', 'task-5-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', null, null, null),
       (6, 0, 3, 'in-progress', 'task-6-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', null, null, null),
       (7, 0, 4, 'in-progress', '{"image": "http://image.com/image1", "bbox": [[100,100],[200,200]]}', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', null, null, null),
       (8, 0, 3, 'free', 'task-8-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', '2017-01-04 12:00:00', null, null),
       (9, 0, 3, 'free', 'task-9-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', '2017-01-04 12:00:00', null, null),
       (10, 0, 3, 'free', 'task-10-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', '2017-01-04 12:00:00', null, null),
       (11, 0, 4, 'free', 'task-11-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', '2017-01-04 12:00:00', null, null),
       (12, 0, 4, 'free', 'task-12-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', '2017-01-04 12:00:00', null, null),
       -- this task has been been posted to Toloka
       (13, 0, 3, 'free', 'task-13-input', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (20, 0, 3, 'new', '{"image": "http://image.com/image20"}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (21, 0, 3, 'in-progress', '{"image": "http://image.com/image21"}', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', null, null, null),
       (22, 0, 3, 'free', '{"image": "http://image.com/image22"}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (23, 0, 4, 'new', '{"image": "http://image.com/image230"}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       (24, 0, 4, 'in-progress', '{"image": "http://image.com/image24"}', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', null, null, null),
       (25, 0, 4, 'free', '{"image": "http://image.com/image25"}', null, 3, '2017-01-01 09:00:00', null, null, null, null),
       -- if task contains string 'known_solution_defected' in its URL, then fake server 'test_server.py' will check for it to contain known_solutions and message_on_unknown_solution fields as well
       (26, 0, 3, 'in-progress', '{"image": "http://image.com/known_solution0"}', null, 3, '2017-01-01 09:00:00', null, null, '[{"output_values": {"state":"has-defect"}, "correctness_weight": 1}]', 'hint'),
       (27, 0, 3, 'in-progress', '{"image": "http://image.com/known_solution1"}', null, 3, '2017-01-01 09:00:00', null, null, '[{"output_values": {"state":"has-defect"}, "correctness_weight": 1}]', 'hint'),
       (28, 0, 3, 'in-progress', '{"image": "http://image.com/known_solution2"}', null, 3, '2017-01-01 09:00:00', null, null, '[{"output_values": {"state":"has-defect"}, "correctness_weight": 1}]', 'hint'),
       (29, 0, 4, 'in-progress', '{"image": "http://image.com/known_solution3"}', null, 3, '2017-01-01 09:00:00', null, null, '[{"output_values": {"state":"no"}, "correctness_weight": 1}]', 'hint'),
       (30, 0, 4, 'in-progress', '{"image": "http://image.com/known_solution4"}', null, 3, '2017-01-01 09:00:00', null, null, '[{"output_values": {"state":"no"}, "correctness_weight": 1}]', 'hint'),
       (31, 0, 4, 'in-progress', '{"image": "http://image.com/known_solution5"}', null, 3, '2017-01-01 09:00:00', null, null, '[{"output_values": {"state":"no"}, "correctness_weight": 1}]', 'hint'),
       (32, 0, 4, 'free', 'task-12-input', null, 3, '2017-01-01 09:00:00', '2017-01-02 09:00:00', null, null, null);

SELECT setval('toloka_mgr.task_id_seq', 100);

-- create toloka tasks
INSERT INTO toloka_mgr.toloka_task (task_suite_id, task_index, task_id)
VALUES (1, 1, 5),
       (1, 2, 6),
       (2, 1, 7),
       (4, 1, 8),
       (4, 2, 9),
       (5, 3, 10),
       (6, 1, 10),
       (7, 1, 11),
       (7, 2, 12),
       (20, 1, 21),
       (21, 1, 24),
       (21, 2, 32);
