#pragma once

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/process/include/process.h>
#include <yandex/maps/mds/mds.h>
#include <yandex/maps/mrc/toloka_client/client.h>
#include <yandex/maps/mrc/unittest/local_server.h>

#include <boost/lexical_cast.hpp>

#include <chrono>
#include <thread>

#include <sys/socket.h>
#include <arpa/inet.h>
#ifdef htonl
#undef htonl
#endif

namespace maps {
namespace mrc {
namespace toloka {
namespace tests {

const std::string LOCAL_HOST = "127.0.0.1";
const char* TOLOKA_AUTH_HEADER = "any";
const char* SERVER_BINARY_PATH
        = "maps/wikimap/mapspro/services/mrc/long_tasks/toloka_manager_cron_jobs/lib/tests/test_server/test_server";

// TODO: move to unittest/stubs and use the config override feature
class TolokaStubFixture
{
public:
    TolokaStubFixture()
        : tolokaStub_([](uint16_t port) {
            return process::Command(
                {BinaryPath(SERVER_BINARY_PATH),
                 LOCAL_HOST,
                 std::to_string(port),
                 SRC_("json")});
        })
        , tolokaClient_(makeTolokaClient())
    {
    }

    io::TolokaClient& tolokaClient() { return tolokaClient_; }

private:
    const unittest::TestServer tolokaStub_;
    io::TolokaClient tolokaClient_;

    io::TolokaClient makeTolokaClient()
    {
        io::TolokaClient client(LOCAL_HOST + ":" + tolokaStub_.getPortStr(), TOLOKA_AUTH_HEADER);
        client.setSchema("http://")
              .setTimeout(std::chrono::seconds(1))
              .setMaxRequestAttempts(5)
              .setRetryInitialTimeout(std::chrono::milliseconds(10))
              .setRetryTimeoutBackoff(1);
        return client;
    }
};

} // tests
} // namespace toloka
} // namespace mrc
} // namespace maps
