#!/usr/bin/env python

from flask import Flask, request, make_response
import datetime
import json
import sys
import os


app = Flask(__name__)
last_pool_id = 0


@app.route('/api/v1/pools/<pool_id>', methods=['GET'])
def get_pool(pool_id):
    with open(os.path.join(JSON_DIR, 'pool.json'), 'r') as pool:
        data = json.loads(pool.read())
        data['id'] = pool_id
        return make_response(json.dumps(data), 200)


@app.route('/api/v1/pools', methods=['POST'])
def create_pool():
    global last_pool_id
    last_pool_id += 1
    with open(os.path.join(JSON_DIR, 'pool.json'), 'r') as pool:
        data = json.loads(pool.read())
        data['id'] = str(last_pool_id)
        return make_response(json.dumps(data), 200)


@app.route('/api/v1/task-suites', methods=['POST'])
def post_task_suite():
    data = json.loads(request.data)
    # check for golden-set tasks (with known solutions)
    for task in data['tasks']:
        goldenset_task = False
        if 'image' in task['input_values']:
            if 'known_solution' in task['input_values']['image']:
                goldenset_task = True
        if goldenset_task and any(field not in task for field in
                                  ['known_solutions',
                                   'message_on_unknown_solution']):
            return make_response("", 400)
    data['id'] = 'task-suite-123'
    data['created'] = datetime.datetime.now().isoformat()
    return make_response(json.dumps(data), 200)


@app.route('/api/v1/task-suites', methods=['GET'])
def get_task_suites():
    with open(os.path.join(JSON_DIR, 'suites.json'), 'r') as suites:
        return make_response(suites.read(), 200)


@app.route('/api/v1/assignments', methods=['GET'])
def get_assignments():
    with open(os.path.join(JSON_DIR, 'assignments.json'), 'r') as assignments:
        return make_response(assignments.read(), 200)


def main(argv=sys.argv):
    global JSON_DIR
    JSON_DIR = sys.argv[3]

    app.run(sys.argv[1], sys.argv[2])

if __name__ == "__main__":
    main()
