#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/juggler/include/juggler.h>
#include <maps/wikimap/mapspro/services/mrc/long_tasks/ugc_uploader/lib/db.h>
#include <maps/wikimap/mapspro/services/mrc/long_tasks/ugc_uploader/lib/utility.h>

namespace juggler = maps::mrc::juggler;
namespace ugc_uploader = maps::mrc::ugc_uploader;
using maps::mrc::db::Ride;
using maps::mrc::db::WalkObject;

int main()
try {
    const auto WARN_COUNT = size_t{100};
    const auto ERROR_COUNT = size_t{300};

    maps::log8::setLevel(maps::log8::Level::FATAL);
    auto config = maps::mrc::common::templateConfig();
    auto postgres = config.makePoolHolder(maps::mrc::common::LONG_READ_DB_ID,
                                          maps::mrc::common::LONG_READ_POOL_ID);
    auto rides =
        ugc_uploader::queueSize<Ride>(*postgres.pool().slaveTransaction());
    auto walkObjects = ugc_uploader::queueSize<WalkObject>(
        *postgres.pool().slaveTransaction());
    auto msg = std::ostringstream{} << "unhandled rides " << rides
                                    << ", walkObjects " << walkObjects;
    if (rides > ERROR_COUNT || walkObjects > ERROR_COUNT) {
        std::cout << juggler::error(msg.str());
    }
    else if (rides > WARN_COUNT || walkObjects > WARN_COUNT) {
        std::cout << juggler::warn(msg.str());
    }
    else {
        std::cout << juggler::ok(msg.str());
    }
    return EXIT_SUCCESS;
}
catch (const std::exception& e) {
    std::cout << juggler::error(e.what());
    return EXIT_SUCCESS;
}
