#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/walk_object.h>

#include <functional>

namespace maps::mrc::ugc_uploader {

template <class Entity>
using Consumer = std::function<void(const Entity&)>;

template <class Entity>
bool queuePop(pgpool3::Pool&, const Consumer<Entity>&);

template <class Entity>
size_t queueSize(sql_chemistry::Transaction&);

auto tryLoadSizedPhoto(sql_chemistry::Transaction&, const db::Ride&)
    -> std::optional<db::Feature>;

auto loadPhotos(sql_chemistry::Transaction&, const db::WalkObject&)
    -> db::Features;

}  // namespace maps::mrc::ugc_uploader
