#pragma once

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/geosearch_client/include/client.h>
#include <yandex/maps/proto/ugc_account/contributions/common/address.pb.h>

namespace maps::mrc::ugc_uploader {

auto makeGeosearchClient(const std::optional<NTvmAuth::TTvmClient>&,
                         const http::URL& geosearchUrl)
    -> geosearch_client::Client;

auto search(geosearch_client::Client&,
            const geolib3::BoundingBox& bboxGeo,
            const std::string& lang)
    -> std::optional<yandex::maps::proto::ugc_account::contributions::common::
                         address::Address>;

}  // namespace maps::mrc::ugc_uploader
