#pragma once

#include "db.h"

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/http/include/url.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride_utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/walk_object.h>

#include <future>

namespace maps::mrc::ugc_uploader {

http::URL makeContributionsModifyUrl(const common::Config&);

void pushContribution(const std::optional<NTvmAuth::TTvmClient>&,
                      const http::URL& contributionsModifyUrl,
                      const http::URL& mrcUgcBackUrl,
                      const db::Ride&,
                      const std::optional<db::Feature>&,
                      const db::FeedbackIdToHypothesisTypeMap&);

void pushContribution(const std::optional<NTvmAuth::TTvmClient>&,
                      const http::URL& contributionsModifyUrl,
                      const http::URL& mrcUgcBackUrl,
                      const http::URL& geosearchUrl,
                      const db::WalkObject&,
                      std::future<db::Features>);

void delWalkObjectContribution(
    const std::optional<NTvmAuth::TTvmClient>&,
    const http::URL& contributionsModifyUrl,
    const db::WalkObject&);

using LangToLocaleMap = std::map<std::string, std::locale>;

const LangToLocaleMap& supportedLocales();

}  // namespace maps::mrc::ugc_uploader
