#include "db.h"

#include <maps/libs/chrono/include/days.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/sql_chemistry/include/batch_load.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>

#include <boost/lexical_cast.hpp>

namespace maps::mrc::user_activity_stat {

TUserActivity loadUserActivity(pgpool3::Pool& pool)
{
    auto result = TUserActivity{};
    auto photos = 0u;
    auto batch = sql_chemistry::BatchLoad<db::table::Feature>{
        BATCH_SIZE,
        db::table::Feature::isPublished &&
            db::table::Feature::userId.isNotNull()};
    while (batch.next(*pool.slaveTransaction())) {
        for (const auto& photo : batch) {
            ++photos;
            auto user = boost::lexical_cast<TId>(photo.userId().value());
            auto day = std::chrono::floor<chrono::Days>(photo.timestamp());
            ++result[user][day];
        }
        INFO() << photos << " photos, " << result.size() << " users read";
    }
    return result;
}

}  // namespace maps::mrc::user_activity_stat
