#pragma once

#include <maps/libs/chrono/include/time_point.h>

#include <string>
#include <unordered_map>

#include <boost/container/flat_map.hpp>

namespace maps::mrc::user_activity_stat {

const std::string APP_NAME = "user_activity_stat";
const std::string LAST_RUN_TIME = APP_NAME + ".timestamp";
const size_t BATCH_SIZE = 100000;

using TId = size_t;
using TCounter = size_t;
using TActivity = boost::container::flat_map<chrono::TimePoint, TCounter>;
using TUserActivity = std::unordered_map<TId, TActivity>;

}  // namespace maps::mrc::user_activity_stat
