CREATE SCHEMA signals;

CREATE TABLE signals.dataset (
    dataset_id bigserial PRIMARY KEY,
    name text NOT NULL
);

CREATE TABLE signals.feature (
    feature_id bigserial PRIMARY KEY,
    dataset_id bigint REFERENCES signals.dataset (dataset_id),
    source_id text NOT NULL,
    pos geometry(point, 3395) NOT NULL,
    heading double precision NOT NULL,
    image_url text NOT NULL,
    date timestamp with time zone NOT NULL,
    mics_data text,
    CONSTRAINT feature_heading_check CHECK (heading >= 0. AND heading < 360.)
);

CREATE INDEX feature_pos_index
    ON signals.feature
    USING gist (pos);

