CREATE SCHEMA targets;

CREATE TYPE targets.direction AS ENUM (
    'FORWARD',
    'BACKWARD',
    'BIDIRECTIONAL'
);

CREATE TABLE targets.target (
    target_id bigserial PRIMARY KEY,
    geom geometry(linestring, 3395) NOT NULL,
    direction targets.direction NOT NULL
);

CREATE INDEX targets_geom_index
    ON targets.target
    USING gist (geom);
