ALTER TABLE signals.feature ADD COLUMN mds_group_id text;

ALTER TABLE signals.feature ADD COLUMN mds_path text;

UPDATE signals.feature
SET
    mds_group_id = source.mds_group_id,
    mds_path = source.mds_path
FROM (SELECT
        feature_id,
        url_path[3] AS mds_group_id,
        array_to_string(ARRAY[url_path[4], url_path[5]], '/') AS mds_path
    FROM (SELECT
            feature_id,
            image_url,
            string_to_array(token, '/') AS url_path
        FROM
            signals.feature,
            LATERAL ts_debug(feature.image_url)
        WHERE alias = 'url_path'
    ) AS dummy
) source
WHERE feature.feature_id = source.feature_id;

ALTER TABLE signals.feature ALTER COLUMN mds_group_id SET NOT NULL;

ALTER TABLE signals.feature ALTER COLUMN mds_path SET NOT NULL;

ALTER TABLE signals.feature DROP COLUMN image_url;
