CREATE SCHEMA toloka_mgr;

CREATE TYPE toloka_mgr.task_status_t AS ENUM (
    'new',
    'in-progress',
    'finished',
    'failed',
    'free'
);

CREATE TABLE toloka_mgr.task_type_info
(
    type_id int PRIMARY KEY,
    name text NOT NULL,
    active_pool_id bigint NOT NULL DEFAULT 0,
    active_pool_size bigint NOT NULL DEFAULT 0
);

CREATE TABLE toloka_mgr.task
(
    id bigserial PRIMARY KEY,
    type_id int NOT NULL REFERENCES toloka_mgr.task_type_info (type_id),
    status toloka_mgr.task_status_t NOT NULL,
    input_values text NOT NULL,
    output_values text,
    overlap int NOT NULL,
    created_at timestamp with time zone NOT NULL,
    posted_at timestamp with time zone,
    solved_at timestamp with time zone
);

CREATE TABLE toloka_mgr.toloka_task_suite
(
    id bigserial NOT NULL PRIMARY KEY,
    toloka_id text NOT NULL,
    toloka_pool_id bigint NOT NULL,
    overlap int NOT NULL,
    created_at timestamp with time zone NOT NULL,
    solved_at timestamp with time zone
);

CREATE TABLE toloka_mgr.toloka_task
(
    task_suite_id bigint REFERENCES toloka_mgr.toloka_task_suite (id),
    task_index integer NOT NULL,
    task_id bigint NOT NULL REFERENCES toloka_mgr.task (id) ON DELETE CASCADE,

    CONSTRAINT toloka_task_pkey PRIMARY KEY (task_suite_id, task_index)
);

CREATE INDEX task_type_id_status_idx ON toloka_mgr.task (type_id, status);
CREATE INDEX toloka_task_id_idx ON toloka_mgr.toloka_task USING btree(task_id);
CREATE INDEX toloka_task_suite_id_idx ON toloka_mgr.toloka_task_suite(id) WHERE solved_at IS NULL;

INSERT INTO toloka_mgr.task_type_info (type_id, name)
VALUES (1, 'sign-detection'), (2, 'sign-classification');
