CREATE TYPE ugc.estimated_position_source_t AS ENUM (
    'error',
    'graph',
    'track'
);

ALTER TABLE ugc.assignment_photo
ADD COLUMN estimated_position geometry(point, 4326),
ADD COLUMN estimated_position_source ugc.estimated_position_source_t;

CREATE TYPE ugc.toloka_status_t AS ENUM (
    'in-progress',
    'accepted',
    'rejected'
);

CREATE TABLE ugc.assignment_review (
    assignment_id bigint NOT NULL REFERENCES ugc.assignment(assignment_id),
    toloka_status ugc.toloka_status_t NOT NULL,
    coverage_fraction double precision NOT NULL
        CHECK (coverage_fraction >= 0 AND coverage_fraction <= 1),
    PRIMARY KEY(assignment_id)
);
