-- ALTER TYPE ugc.estimated_position_source_t ADD VALUE IF NOT EXISTS 'client';
-- But enum type can't be altered in transaction block.
-- So instead of this command we need to define a new enum type
-- and migrate column to this type.

SET search_path=ugc,public;

ALTER TYPE estimated_position_source_t
    RENAME TO estimated_position_source_t_;

CREATE TYPE estimated_position_source_t AS ENUM (
    'error',
    'graph',
    'track',
    'client'
);

ALTER TABLE assignment_photo
    ALTER COLUMN estimated_position_source
    TYPE estimated_position_source_t
    USING estimated_position_source::text::estimated_position_source_t;

DROP TYPE estimated_position_source_t_;

SET search_path=public;

