CREATE TABLE signs_detect.hypotheses (
    hypothesis_id bigserial PRIMARY KEY,
    type text NOT NULL,
    position geometry(Point, 3395) NOT NULL,
    object_id bigint NOT NULL,
    commit_id bigint NOT NULL,
    sign_id bigint NOT NULL REFERENCES signs_detect.sign(sign_id) ON DELETE CASCADE,
    context jsonb NOT NULL
);

CREATE INDEX ON signs_detect.hypotheses USING btree(type);
CREATE INDEX ON signs_detect.hypotheses USING btree(object_id, commit_id);
CREATE INDEX ON signs_detect.hypotheses USING btree(sign_id);
CREATE INDEX ON signs_detect.hypotheses USING gist(position);
