ALTER TABLE signals.feature
    ALTER COLUMN pos
        DROP NOT NULL,
    ALTER COLUMN heading
        DROP NOT NULL,
    ADD CONSTRAINT feature_pos_null_check
        CHECK (pos IS NOT NULL)
        NO INHERIT,
    ADD CONSTRAINT feature_heading_null_check
        CHECK (heading IS NOT NULL)
        NO INHERIT,
    ALTER COLUMN dataset
        SET NOT NULL,
    ALTER COLUMN is_published
        SET NOT NULL,
    ALTER COLUMN was_uploaded_to_s3mds
        SET NOT NULL,
    ALTER COLUMN was_uploaded_to_s3mds
        SET DEFAULT FALSE,
    ADD CONSTRAINT feature_is_published_null_check
        CHECK (pos IS NOT NULL AND heading IS NOT NULL OR NOT is_published);
