CREATE TABLE signals.ride_photo (
    user_id text NOT NULL,
    relevance double precision CHECK (relevance >= 0 AND relevance <= 1)
)
INHERITS (signals.feature);

ALTER TABLE signals.ride_photo
    ADD PRIMARY KEY (feature_id);

CREATE INDEX ride_photo_pos_is_published_index
    ON signals.ride_photo USING gist
	(pos)
	WHERE is_published;

CREATE INDEX ride_photo_source_id_date_index
    ON signals.ride_photo USING btree
	(source_id, date);
