CREATE TABLE ugc.assignment_object (
    object_id bigserial PRIMARY KEY,
    assignment_id bigint NOT NULL REFERENCES ugc.assignment(assignment_id) ON DELETE CASCADE,
    created_at timestamp with time zone NOT NULL,
    position public.geometry(Point,4326) NOT NULL,
    type text,
    comment text
);

ALTER TABLE ugc.assignment_object ADD CONSTRAINT assignment_object_type_check
    CHECK (type IS NOT NULL AND
           type IN ('barrier', 'deadend', 'bad_conditions', 'no_entry'));
