CREATE TABLE signals.track_point (
    id bigserial NOT NULL,
    source_id text NOT NULL,
    pos geometry(Point,3395) NOT NULL,
    date timestamp with time zone NOT NULL,
    accuracy double precision,
    heading double precision,
    speed double precision,
    CONSTRAINT track_point_heading_check CHECK (heading >= 0. AND heading < 360.)
);

CREATE TABLE signals.ride_track_point (
)
INHERITS (signals.track_point);

CREATE INDEX ride_track_point_source_id_date_index
    ON signals.ride_track_point
    (source_id, date);
