CREATE TABLE signals.assignment_photo (
    assignment_id bigint NOT NULL REFERENCES ugc.assignment(assignment_id)
)
INHERITS (signals.feature);

ALTER TABLE signals.assignment_photo
    ADD PRIMARY KEY (feature_id);

CREATE INDEX assignment_photo_pos_index
    ON signals.assignment_photo USING gist
	(pos);

CREATE INDEX assignment_photo_source_id_date_index
    ON signals.assignment_photo USING btree
	(source_id, date);

CREATE INDEX assignment_photo_assignment_id_index
    ON signals.assignment_photo USING btree
    (assignment_id);



CREATE TABLE signals.assignment_track_point (
    assignment_id bigint NOT NULL REFERENCES ugc.assignment(assignment_id)
)
INHERITS (signals.track_point);

CREATE INDEX assignment_track_point_source_id_date_index
    ON signals.assignment_track_point
    (source_id, date);

CREATE INDEX assignment_track_point_assignment_id_index
    ON signals.assignment_track_point USING btree
    (assignment_id);



ALTER TABLE ugc.assignment_photo
    DROP CONSTRAINT IF EXISTS assignment_photo_feature_id_fkey;
