CREATE TABLE signals.feature_transaction(
    feature_id bigserial NOT NULL,
    transaction_id bigint NOT NULL
);

CREATE UNIQUE INDEX feature_transaction_table_feature_unique_index
    ON signals.feature_transaction USING btree(feature_id);

CREATE INDEX feature_transaction_table_transaction_index
    ON signals.feature_transaction USING btree(transaction_id);

LOCK TABLE signals.feature IN SHARE MODE;

INSERT INTO signals.feature_transaction (feature_id, transaction_id)
    SELECT feature_id,  txid_current() AS transaction_id FROM signals.feature;

CREATE OR REPLACE FUNCTION update_feature_transaction() RETURNS TRIGGER AS $$
BEGIN
    IF TG_OP = 'INSERT' THEN
        INSERT INTO signals.feature_transaction(feature_id, transaction_id)
            VALUES (NEW.feature_id, txid_current())
        ;

        RETURN NEW;
    ELSIF TG_OP = 'UPDATE' THEN
        UPDATE signals.feature_transaction
            SET transaction_id = txid_current()
            WHERE feature_transaction.feature_id = NEW.feature_id
        ;

        RETURN NEW;
    ELSE
        DELETE FROM signals.feature_transaction WHERE feature_id = OLD.feature_id;

        RETURN OLD;
    END IF;
END;
$$ language plpgsql;

CREATE TRIGGER update_feature_transaction_on_update_feature
    AFTER INSERT OR UPDATE OR DELETE ON signals.feature
    FOR EACH ROW EXECUTE PROCEDURE update_feature_transaction();

CREATE TRIGGER update_feature_transaction_on_update_feature
    AFTER INSERT OR UPDATE OR DELETE ON signals.ride_photo
    FOR EACH ROW EXECUTE PROCEDURE update_feature_transaction();

CREATE TRIGGER update_feature_transaction_on_update_feature
    AFTER INSERT OR UPDATE OR DELETE ON signals.assignment_photo
    FOR EACH ROW EXECUTE PROCEDURE update_feature_transaction();
