CREATE TYPE ugc.tasks_group_status AS ENUM (
    'draft',
    'open',
    'generating',
    'in_progress',
    'closed',
    'failed'
);

CREATE TABLE ugc.tasks_group (
    tasks_group_id serial PRIMARY KEY,
    status ugc.tasks_group_status NOT NULL,
    name text NOT NULL,
    geom geometry(MULTIPOLYGON, 3395) NOT NULL,
    routing boolean NOT NULL,
    fcs integer[] NOT NULL,
    toll boolean NOT NULL,
    recommended_task_length_meters integer NOT NULL,
    actualized_before timestamp with time zone,
    total_length_meters integer,
    unique_length_meters integer,
    graph_coverage_ratio real
);


CREATE INDEX ON ugc.tasks_group USING btree(status);
CREATE INDEX ON ugc.tasks_group USING gist(geom);


ALTER TABLE ugc.task ADD COLUMN tasks_group_id bigint
    REFERENCES ugc.tasks_group(tasks_group_id);
CREATE INDEX ON ugc.task USING btree(tasks_group_id);

