CREATE TABLE signals.walk_photo
(
    user_id text NOT NULL
)
INHERITS (signals.feature);

ALTER TABLE signals.walk_photo ADD PRIMARY KEY (feature_id);

CREATE TRIGGER delete_sign_feature_on_feature_deletion
    AFTER DELETE ON signals.walk_photo
    FOR EACH ROW EXECUTE PROCEDURE delete_sign_feature_on_feature_deletion();

CREATE TRIGGER update_feature_transaction_on_update_feature
    AFTER INSERT OR UPDATE OR DELETE ON signals.walk_photo
    FOR EACH ROW EXECUTE PROCEDURE update_feature_transaction();

CREATE TABLE signals.walk_object
(
    id bigserial PRIMARY KEY,
    device_id text NOT NULL,
    user_id text NOT NULL,
    created_at timestamp with time zone NOT NULL,
    published_at timestamp with time zone,
    feedback_type text
        NOT NULL
        CHECK (feedback_type = ANY(ARRAY['none', 'barrier', 'deadend', 'bad_conditions', 'no_entry']))
        DEFAULT 'none',
    pos geometry(Point,3395) NOT NULL,
    feature_id bigint REFERENCES signals.walk_photo(feature_id),
    comment text NOT NULL DEFAULT '',
    feedback_task_id bigint,
    toloka_id bigint REFERENCES toloka_mgr.task(id),
    status text
        NOT NULL
        CHECK (status = ANY(ARRAY['private', 'pending', 'discarded', 'on_moderation', 'published']))
        DEFAULT 'pending'
);

COMMENT ON COLUMN signals.walk_object.feedback_task_id IS 'Task ID received from Feedback API';
