-- The table below reflects which feature are covering an edge. It is
-- a many to many relation because one feature may cover multiple edges
-- and one edge is typically covered by many features.
CREATE TABLE road_graph.edge_covering_feature (
    persistent_edge_id text NOT NULL REFERENCES road_graph.covered_edge (persistent_edge_id)
        ON DELETE CASCADE,
    feature_id bigint NOT NULL REFERENCES signals.feature_transaction (feature_id)
);

CREATE INDEX edge_covering_feature_feature_id_index
    ON road_graph.edge_covering_feature (feature_id);

CREATE INDEX edge_covering_feature_persistent_edge_id_index
    ON road_graph.edge_covering_feature (persistent_edge_id);

-- From now on deletion of a feature doesn't remove feature_id from the transactions
-- table but rather update transaction_id it was deleted in.
CREATE OR REPLACE FUNCTION update_feature_transaction() RETURNS TRIGGER AS $$
BEGIN
    IF TG_OP = 'INSERT' THEN
        INSERT INTO signals.feature_transaction(feature_id, transaction_id)
            VALUES (NEW.feature_id, txid_current())
        ;

        RETURN NEW;
    ELSIF TG_OP = 'UPDATE' THEN
        UPDATE signals.feature_transaction
            SET transaction_id = txid_current()
            WHERE feature_transaction.feature_id = NEW.feature_id
        ;

        RETURN NEW;
    ELSE
        UPDATE signals.feature_transaction
            SET transaction_id = txid_current()
            WHERE feature_transaction.feature_id = OLD.feature_id
        ;

        RETURN OLD;
    END IF;
END;
$$ language plpgsql;
