CREATE TABLE service.region_privacy_params (
    geo_id bigint PRIMARY KEY,
    show_photos boolean NOT NULL
);


CREATE TABLE signals.object_in_photo (
    id bigserial PRIMARY KEY,
    feature_id bigint NOT NULL,
    type text CHECK (type IS NOT NULL AND type IN ('face', 'license_plate')) ,
    min_x integer NOT NULL,
    min_y integer NOT NULL,
    max_x integer NOT NULL,
    max_y integer NOT NULL,
    confidence float NOT NULL CHECK(confidence > 0. AND confidence <= 1.)
);


CREATE CONSTRAINT TRIGGER constraint_object_in_photo_feature_id_foreign_key
    AFTER INSERT OR UPDATE ON signals.object_in_photo
    FOR EACH ROW EXECUTE PROCEDURE check_feature_id_exists();

CREATE OR REPLACE FUNCTION delete_object_in_photo_on_feature_deletion() RETURNS TRIGGER AS $$
DECLARE
BEGIN
    DELETE FROM signals.object_in_photo WHERE feature_id = OLD.feature_id;
    RETURN OLD;
END;
$$ language plpgsql;

CREATE TRIGGER delete_object_in_photo_on_feature_deletion
    AFTER DELETE ON  signals.feature
    FOR EACH ROW EXECUTE PROCEDURE delete_object_in_photo_on_feature_deletion();

CREATE TRIGGER delete_object_in_photo_on_feature_deletion
    AFTER DELETE ON signals.ride_photo
    FOR EACH ROW EXECUTE PROCEDURE delete_object_in_photo_on_feature_deletion();

CREATE TRIGGER delete_object_in_photo_on_feature_deletion
    AFTER DELETE ON signals.assignment_photo
    FOR EACH ROW EXECUTE PROCEDURE delete_object_in_photo_on_feature_deletion();
