ALTER TABLE signals.feature
    ADD COLUMN camera_deviation smallint,
    ADD CONSTRAINT camera_deviation_check
        CHECK (camera_deviation IS NULL
            OR camera_deviation IN (0, 90, 180, 270));

COMMENT ON COLUMN signals.feature.camera_deviation IS
    'degrees between heading and camera direction, measured clockwise';

ALTER TABLE ugc.tasks_group
    ADD COLUMN camera_deviations smallint[],
    ADD CONSTRAINT camera_deviations_check
        CHECK (camera_deviations IS NULL
            OR camera_deviations <@ ARRAY[0, 90, 180, 270]::smallint[]);

COMMENT ON COLUMN ugc.tasks_group.camera_deviations IS
    'degrees between heading and camera direction, measured clockwise';

ALTER TABLE ugc.task
    ADD COLUMN camera_deviations smallint[],
    ADD CONSTRAINT camera_deviations_check
        CHECK (camera_deviations IS NULL
            OR camera_deviations <@ ARRAY[0, 90, 180, 270]::smallint[]);

COMMENT ON COLUMN ugc.task.camera_deviations IS
    'degrees between heading and camera direction, measured clockwise';

ALTER TABLE ugc.assignment_review
    DROP CONSTRAINT assignment_review_pkey,
    ADD COLUMN camera_deviation smallint NOT NULL DEFAULT 0,
    ADD CONSTRAINT camera_deviation_check
        CHECK (camera_deviation IN (0, 90, 180, 270)),
    ADD PRIMARY KEY (assignment_id, camera_deviation);

COMMENT ON COLUMN ugc.assignment_review.camera_deviation IS
    'degrees between heading and camera direction, measured clockwise';

CREATE TABLE road_graph.covered_edge_v2 (
    persistent_edge_id text NOT NULL,
    camera_deviation smallint NOT NULL DEFAULT 0,
    coverage_fraction real NOT NULL,
    actualization_date timestamp with time zone NOT NULL,
    CONSTRAINT camera_deviation_check
        CHECK (camera_deviation IN (0, 90, 180, 270)),
    CONSTRAINT coverage_fraction_check
        CHECK (.0 < coverage_fraction AND coverage_fraction <= 1.),
    PRIMARY KEY (persistent_edge_id, camera_deviation)
);

COMMENT ON COLUMN road_graph.covered_edge_v2.camera_deviation IS
    'degrees between heading and camera direction, measured clockwise';

CREATE TABLE road_graph.edge_covering_feature_v2 (
    persistent_edge_id text NOT NULL,
    camera_deviation smallint NOT NULL DEFAULT 0,
    feature_id bigint NOT NULL
        REFERENCES signals.feature_transaction (feature_id),
    CONSTRAINT camera_deviation_check
        CHECK (camera_deviation IN (0, 90, 180, 270)),
    FOREIGN KEY (persistent_edge_id, camera_deviation)
        REFERENCES road_graph.covered_edge_v2 (persistent_edge_id, camera_deviation)
        ON DELETE CASCADE
);

COMMENT ON COLUMN road_graph.edge_covering_feature_v2.camera_deviation IS
    'degrees between heading and camera direction, measured clockwise';

CREATE INDEX edge_covering_feature_v2_feature_id_idx
    ON road_graph.edge_covering_feature (feature_id);

CREATE INDEX edge_covering_feature_v2_persistent_edge_id_camera_deviation_idx
    ON road_graph.edge_covering_feature_v2 (persistent_edge_id, camera_deviation);
