DROP TABLE IF EXISTS road_graph.edge_covering_feature;

DROP TABLE IF EXISTS road_graph.covered_edge;

CREATE TABLE road_graph.covered_edge (
    persistent_edge_id text NOT NULL,
    camera_deviation smallint NOT NULL DEFAULT 0,
    coverage_fraction real NOT NULL,
    actualization_date timestamp with time zone NOT NULL,
    CONSTRAINT camera_deviation_check
        CHECK (camera_deviation IN (0, 90, 180, 270)),
    CONSTRAINT coverage_fraction_check
        CHECK (.0 < coverage_fraction AND coverage_fraction <= 1.),
    PRIMARY KEY (persistent_edge_id, camera_deviation)
);

COMMENT ON COLUMN road_graph.covered_edge.camera_deviation IS
    'degrees between heading and camera direction, measured clockwise';

CREATE TABLE road_graph.edge_covering_feature (
    persistent_edge_id text NOT NULL,
    camera_deviation smallint NOT NULL DEFAULT 0,
    feature_id bigint NOT NULL
        REFERENCES signals.feature_transaction (feature_id),
    CONSTRAINT camera_deviation_check
        CHECK (camera_deviation IN (0, 90, 180, 270)),
    FOREIGN KEY (persistent_edge_id, camera_deviation)
        REFERENCES road_graph.covered_edge (persistent_edge_id, camera_deviation)
        ON DELETE CASCADE
);

COMMENT ON COLUMN road_graph.edge_covering_feature.camera_deviation IS
    'degrees between heading and camera direction, measured clockwise';

CREATE INDEX edge_covering_feature_feature_id_idx
    ON road_graph.edge_covering_feature (feature_id);

CREATE INDEX edge_covering_feature_persistent_edge_id_camera_deviation_idx
    ON road_graph.edge_covering_feature (persistent_edge_id, camera_deviation);
