CREATE SCHEMA house;

CREATE TABLE house.house_number (
    house_number_id bigserial PRIMARY KEY,
    number text NOT NULL,
    position geometry(point, 3395) NOT NULL,
    feedback_task_id bigint
);

CREATE INDEX house_number_position_index ON house.house_number USING gist (position);
CREATE INDEX house_number_number_index ON house.house_number USING btree (number);

CREATE TABLE house.house_number_feature (
    house_number_id bigint REFERENCES house.house_number (house_number_id) ON DELETE CASCADE,
    feature_id bigint REFERENCES signals.feature (feature_id) ON DELETE CASCADE,

    min_x int NOT NULL,
    min_y int NOT NULL,
    max_x int NOT NULL,
    max_y int NOT NULL,

    UNIQUE (house_number_id, feature_id, min_x, min_y, max_x, max_y)
);

CREATE INDEX house_number_feature_house_number_id_index ON house.house_number_feature USING btree (house_number_id);
CREATE INDEX house_number_feature_feature_id_index ON house.house_number_feature USING btree (feature_id);
