ALTER TABLE house.house_number_feature DROP CONSTRAINT IF EXISTS house_number_feature_feature_id_fkey CASCADE;

CREATE CONSTRAINT TRIGGER constraint_feature_id_exists
    AFTER INSERT OR UPDATE ON house.house_number_feature
    FOR EACH ROW EXECUTE PROCEDURE check_feature_id_exists();

CREATE OR REPLACE FUNCTION delete_house_number_feature_on_feature_deletion() RETURNS TRIGGER AS $$
DECLARE
BEGIN
    DELETE FROM house.house_number_feature WHERE feature_id = OLD.feature_id;
    RETURN OLD;
END;
$$ language plpgsql;

CREATE TRIGGER delete_house_number_feature_on_feature_deletion
    AFTER DELETE ON  signals.feature
    FOR EACH ROW EXECUTE PROCEDURE delete_house_number_feature_on_feature_deletion();

CREATE TRIGGER delete_house_number_feature_on_feature_deletion
    AFTER DELETE ON signals.ride_photo
    FOR EACH ROW EXECUTE PROCEDURE delete_house_number_feature_on_feature_deletion();

CREATE TRIGGER delete_house_number_feature_on_feature_deletion
    AFTER DELETE ON signals.assignment_photo
    FOR EACH ROW EXECUTE PROCEDURE delete_house_number_feature_on_feature_deletion();

CREATE TRIGGER delete_house_number_feature_on_feature_deletion
    AFTER DELETE ON signals.walk_photo
    FOR EACH ROW EXECUTE PROCEDURE delete_house_number_feature_on_feature_deletion();

