CREATE TABLE IF NOT EXISTS signals.panorama(
    panorama_id bigserial PRIMARY KEY,
    mds_key text NOT NULL,
    mds_src_key text NOT NULL,
    date timestamp NOT NULL,
    session_id bigint NOT NULL,
    order_num integer NOT NULL,
    position geometry(Point, 4326) NOT NULL,
    vehicle_course_deg real NOT NULL,
    horizontal_angle_deg real NOT NULL,
    vertical_angle_deg real NOT NULL,
    tile_width integer NOT NULL,
    tile_height integer NOT NULL,
    total_width integer NOT NULL,
    total_height integer NOT NULL,
    zoom_level smallint NOT NULL
);

COMMENT ON TABLE signals.panorama IS
'http://ecstatic.maps.yandex.net/pkg/yandex-maps-streetview-description/versions';

COMMENT ON COLUMN signals.panorama.mds_key IS
'mds key of panorama tiles';

COMMENT ON COLUMN signals.panorama.mds_src_key IS
'mds key of source panorama image (full size)';

COMMENT ON COLUMN signals.panorama.date IS
'date the panorama image was taken';

COMMENT ON COLUMN signals.panorama.session_id IS
'ID of session during which a panorama is taken';

COMMENT ON COLUMN signals.panorama.order_num IS
'sequential panorama number within a session it was taken in';

COMMENT ON COLUMN signals.panorama.position IS
'panorama position';

COMMENT ON COLUMN signals.panorama.vehicle_course_deg IS
'vehicle course at the moment the panorama was taken';

COMMENT ON COLUMN signals.panorama.horizontal_angle_deg IS
'angle between the horizon and an image center';

COMMENT ON COLUMN signals.panorama.vertical_angle_deg IS
'CW angle between true North and a panorama cut line (horizontal side)';

COMMENT ON COLUMN signals.panorama.total_width IS
'total panorama projection image width';

COMMENT ON COLUMN signals.panorama.total_height IS
'total panorama projection image height';

COMMENT ON COLUMN signals.panorama.tile_width IS
'width of a panorama tile (an edge tile width may be narrower)';

COMMENT ON COLUMN signals.panorama.tile_height IS
'height of a panorama tile (an edge tile height may be lower)';

COMMENT ON COLUMN signals.panorama.zoom_level IS
'panorama zoom level which is used in tiles addressing';
