CREATE TABLE signs_detect.sign_panorama (
    sign_id bigint REFERENCES signs_detect.sign (sign_id) ON DELETE CASCADE,
    panorama_id bigint REFERENCES signals.panorama (panorama_id) ON DELETE CASCADE,

    min_x int NOT NULL,
    min_y int NOT NULL,
    max_x int NOT NULL,
    max_y int NOT NULL,

    CONSTRAINT sign_panorama_box_check CHECK (
        0 <= min_x AND 0 <= min_y AND min_x <= max_x AND min_y <= max_y
    )
);

COMMENT ON TABLE signs_detect.sign_panorama IS
'Many to many relation between signs and panoramas';

COMMENT ON COLUMN signs_detect.sign_panorama.min_x IS
'Left bbox position in panorama pixel coordinates';

COMMENT ON COLUMN signs_detect.sign_panorama.min_y IS
'Top bbox position in panorama pixel coordinates';

COMMENT ON COLUMN signs_detect.sign_panorama.max_x IS
'Right bbox position in panorama pixel coordinates';

COMMENT ON COLUMN signs_detect.sign_panorama.max_y IS
'Bottom bbox position in panorama pixel coordinates';
