CREATE TABLE house.house_number_panorama (
    house_number_id bigint REFERENCES house.house_number (house_number_id) ON DELETE CASCADE,
    panorama_id bigint REFERENCES signals.panorama (panorama_id) ON DELETE CASCADE,

    min_x int NOT NULL,
    min_y int NOT NULL,
    max_x int NOT NULL,
    max_y int NOT NULL,

    UNIQUE (house_number_id, panorama_id, min_x, min_y, max_x, max_y)
);

CREATE INDEX house_number_panorama_house_number_id_index ON house.house_number_panorama USING btree (house_number_id);
CREATE INDEX house_number_panorama_panorama_id_index ON house.house_number_panorama USING btree (panorama_id);
