-- 1. Delete is_experimental column from package_rollout
DROP INDEX IF EXISTS drive.package_rollout_name_scope_experimental_index;
ALTER TABLE drive.package_rollout
    DROP COLUMN is_experimental;

-- 2. Rename s3_key -> url
ALTER TABLE drive.package
    RENAME COLUMN s3_key TO url;

-- 3. Add mapping from device to branch
CREATE TABLE drive.device_branch (
    device_id text PRIMARY KEY,
    branch drive.branch_t NOT NULL
);

-- 4. Delete device_id from scope
DROP INDEX IF EXISTS drive.scope_hw_arch_branch_device_idx;
DROP INDEX IF EXISTS drive.scope_hw_arch_branch_null_idx;
ALTER TABLE drive.scope
    DROP COLUMN device_id,
    ADD CONSTRAINT scope_hardware_arch_branch_key UNIQUE (hardware, arch, branch);