CREATE SCHEMA eye;

CREATE TABLE eye.device (
    device_id bigserial PRIMARY KEY,
    txn_id bigint NOT NULL,
    attrs jsonb NOT NULL
);

CREATE INDEX eye_device_txn_id_index ON eye.device USING btree(txn_id);

CREATE TABLE eye.frame(
    frame_id bigserial PRIMARY KEY,
    device_id bigint NOT NULL REFERENCES eye.device (device_id) ON DELETE CASCADE,
    txn_id bigserial NOT NULL,
    deleted boolean NOT NULL,
    orientation smallint NOT NULL, -- exif orientation
    url_context jsonb NOT NULL,
    time timestamp with time zone NOT NULL,

    CONSTRAINT eye_frame_orientation_check CHECK (1 <= orientation AND orientation <= 8)
);

CREATE INDEX eye_frame_txn_id_index ON eye.frame USING btree(txn_id);
CREATE INDEX eye_frame_device_id_time_index ON eye.frame USING btree(device_id, time);

CREATE TABLE eye.frame_location(
    frame_id bigint NOT NULL REFERENCES eye.frame (frame_id) ON DELETE CASCADE,
    txn_id bigserial NOT NULL,
    position geometry(point, 3395) NOT NULL,
    rotation real[4] NOT NULL, -- from global axes to frame ones (quaternion)
    move real[3] -- unit vector in global axes
);

CREATE UNIQUE INDEX eye_frame_location_frame_id ON eye.frame_location USING btree(frame_id);
CREATE INDEX eye_frame_location_txn_id_index ON eye.frame_location USING btree(txn_id);
CREATE INDEX eye_frame_location_position_index ON eye.frame_location USING gist(position);

CREATE TABLE eye.frame_privacy(
    frame_id bigint NOT NULL REFERENCES eye.frame (frame_id) ON DELETE CASCADE,
    txn_id bigserial NOT NULL,
    type text NOT NULL,

    CONSTRAINT eye_frame_privacy_check CHECK (type IN ('public', 'restricted', 'secret'))
);

CREATE UNIQUE INDEX eye_frame_privacy_frame_id ON eye.frame_privacy USING btree(frame_id);
CREATE INDEX eye_frame_privacy_txn_id_index ON eye.frame_privacy USING btree(txn_id);
