CREATE TABLE eye.feature_to_frame (
    feature_id bigint NOT NULL,
    frame_id bigint NOT NULL REFERENCES eye.frame (frame_id) ON DELETE CASCADE
);

CREATE CONSTRAINT TRIGGER constraint_feature_id_exists
    AFTER INSERT OR UPDATE ON eye.feature_to_frame
    FOR EACH ROW EXECUTE PROCEDURE check_feature_id_exists();

CREATE UNIQUE INDEX eye_feature_to_frame_feature_id_index ON eye.feature_to_frame USING btree(feature_id);
CREATE UNIQUE INDEX eye_feature_to_frame_frame_id_index ON eye.feature_to_frame USING btree(frame_id);

CREATE TABLE eye.feature_source_to_device (
    source_id text NOT NULL,
    device_id bigint NOT NULL REFERENCES eye.device(device_id) ON DELETE CASCADE
);

CREATE UNIQUE INDEX eye_feature_source_to_device_device_id_index ON eye.feature_source_to_device USING btree(device_id);
CREATE UNIQUE INDEX eye_feature_source_to_device_source_id_index ON eye.feature_source_to_device USING btree(source_id);
