CREATE TABLE eye.recognition (
    recognition_id bigserial PRIMARY KEY,
    frame_id bigint NOT NULL REFERENCES eye.frame (frame_id) ON DELETE CASCADE,
    txn_id bigint NOT NULL,
    orientation smallint NOT NULL, -- exif orientation, [1..8]
    type text NOT NULL,
    source text NOT NULL,
    value jsonb,

    CONSTRAINT eye_recognition_orientation_check CHECK (1 <= orientation AND orientation <= 8),

    CONSTRAINT eye_recognition_type_check CHECK (
        type IN (
            'detect_sign',
            'detect_traffic_light',
            'detect_houser_number',
            'detect_road_marking',
            'detect_panel'
        )
    ),

    CONSTRAINT eye_recognition_source_check CHECK (source IN ('model', 'toloka'))
);

CREATE UNIQUE INDEX eye_recognition_unique_index ON eye.recognition USING btree(frame_id, orientation, type, source);
CREATE INDEX eye_recognition_txn_id_index ON eye.recognition USING btree(txn_id);

CREATE TABLE eye.detection_group (
    group_id bigserial PRIMARY KEY,
    frame_id bigint NOT NULL REFERENCES eye.frame (frame_id) ON DELETE CASCADE,
    txn_id bigint NOT NULL,
    type text NOT NULL,
    approved boolean NOT NULL

    CONSTRAINT eye_detection_group_type_check CHECK (
        type IN ('sign', 'traffic_light', 'house_number', 'road_marking')
    )
);

CREATE UNIQUE INDEX eye_detection_group_unique_index ON eye.detection_group USING btree(frame_id, type);
CREATE INDEX eye_detection_group_txn_id_index ON eye.detection_group USING btree(txn_id);
CREATE INDEX eye_detection_group_type_index ON eye.detection_group USING btree(type);

CREATE TABLE eye.detection (
    detection_id bigserial PRIMARY KEY,
    group_id bigint NOT NULL REFERENCES eye.detection_group (group_id) ON DELETE CASCADE,
    txn_id bigint NOT NULL,
    deleted boolean NOT NULL,
    box integer[4] NOT NULL, -- [min_x, min_y, max_x, max_y]
    attrs jsonb NOT NULL

    CONSTRAINT eye_detection_box_check CHECK (
        (0 <= box[0] AND box[0] <= box[2])
            AND (0 <= box[1] AND box[1] <= box[3])
    )
);

CREATE INDEX eye_detection_group_id_index ON eye.detection USING btree(group_id);
CREATE INDEX eye_detection_txn_id_index ON eye.detection USING btree(txn_id);