CREATE TABLE traffic_light.traffic_light_toloka (
    hypothesis_id bigint NOT NULL UNIQUE REFERENCES traffic_light.hypotheses (hypothesis_id) ON DELETE CASCADE,

    workflow_id text NOT NULL,
    workflow_instance_id text NOT NULL,
    block_guid text NOT NULL,
    state text NOT NULL
);

CREATE INDEX traffic_light_toloka_hypothesis_id_index ON traffic_light.traffic_light_toloka USING btree (hypothesis_id);
CREATE INDEX traffic_light_toloka_state_index ON traffic_light.traffic_light_toloka USING btree (state);
CREATE INDEX traffic_light_toloka_workflow_instance_block_index ON traffic_light.traffic_light_toloka USING btree (workflow_id, workflow_instance_id, block_guid);
