CREATE TYPE eye.hypothesis_type AS ENUM (
    'absent_traffic_light',
    'absent_house_number'
);

CREATE TABLE eye.hypothesis (
    hypothesis_id bigserial PRIMARY KEY,
    txn_id bigserial NOT NULL,
    deleted boolean NOT NULL,
    position geometry(Point, 3395) NOT NULL,
    type eye.hypothesis_type NOT NULL,
    attrs jsonb NOT NULL
);

CREATE INDEX eye_hypothesis_txn_id_index ON eye.hypothesis USING btree(txn_id);
CREATE INDEX eye_hypothesis_position_index ON eye.hypothesis USING gist(position);

CREATE TABLE eye.hypothesis_object(
    hypothesis_object_id bigserial PRIMARY KEY,
    hypothesis_id bigint NOT NULL REFERENCES eye.hypothesis (hypothesis_id),
    object_id bigint NOT NULL REFERENCES eye.object (object_id),
    txn_id bigserial NOT NULL,
    deleted boolean NOT NULL
);

CREATE INDEX eye_hypothesis_object_hypothesis_id_index ON eye.hypothesis_object USING btree(hypothesis_id);
CREATE INDEX eye_hypothesis_object_object_id_index ON eye.hypothesis_object USING btree(object_id);
CREATE UNIQUE INDEX eye_hypothesis_object_hypothesis_id_object_id_index ON eye.hypothesis_object USING btree(hypothesis_id, object_id);
CREATE INDEX eye_hypothesis_object_txn_id_index ON eye.hypothesis_object USING btree(txn_id);
