CREATE EXTENSION IF NOT EXISTS btree_gist;


CREATE TABLE rides.ride (
    ride_id bigserial PRIMARY KEY,
    user_id text NOT NULL,
    start_time timestamp with time zone NOT NULL,
    end_time timestamp with time zone NOT NULL,
    source_id text NOT NULL,
    track geometry(LineString, 3395) NOT NULL,
    distance_in_meters double precision NOT NULL,
    photos bigint NOT NULL,
    upload_start_time timestamp with time zone NOT NULL,
    upload_end_time timestamp with time zone NOT NULL,
    is_deleted boolean NOT NULL,

    CONSTRAINT ride_time_check CHECK (
        start_time <= end_time
    ),

    CONSTRAINT ride_uploading_time_check CHECK (
        upload_start_time <= upload_end_time
    ),

    CONSTRAINT ride_overlapping_times EXCLUDE USING GIST (
        source_id WITH =,
        TSTZRANGE(start_time, end_time) WITH &&
    )
);


CREATE INDEX ride_user_start_end_index
    ON rides.ride (user_id, start_time, end_time DESC);
