ALTER TABLE signals.ride_photo
    ADD COLUMN gdpr_deleted boolean;

ALTER TABLE signals.walk_photo
    ADD COLUMN gdpr_deleted boolean;

ALTER TABLE rides.ride
    ADD COLUMN gdpr_deleted boolean;

CREATE TABLE service.takeout_data_erasure (
    id bigserial PRIMARY KEY,
    takeout_request_id text NOT NULL,
    user_id text NOT NULL,
    requested_at timestamp with time zone NOT NULL, 
    finished_at timestamp with time zone,
    grinder_task_id text
);

CREATE INDEX takeout_data_erasure_user_id_requested_at_idx
    ON service.takeout_data_erasure (user_id, requested_at);
