ALTER TABLE signals.feature
    ADD COLUMN moderators_should_be_published boolean;

ALTER TABLE signals.ride_photo
    ADD COLUMN show_authorship boolean,
    ADD COLUMN deleted_by_user boolean;

CREATE TYPE rides.ride_status AS ENUM (
    'pending',
    'processed'
);

ALTER TABLE rides.ride
    ADD COLUMN show_authorship boolean,
    ADD COLUMN status rides.ride_status;

CREATE TABLE rides.deleted_interval (
    deleted_interval_id bigserial PRIMARY KEY,
    user_id text NOT NULL,
    source_id text NOT NULL,
    started_at timestamp with time zone NOT NULL,
    ended_at timestamp with time zone NOT NULL,
    created_at timestamp with time zone NOT NULL, 

    CONSTRAINT time_check CHECK (
        started_at <= ended_at
    )
);

CREATE INDEX deleted_interval_user_source_start_end_index
    ON rides.deleted_interval (user_id, source_id, started_at, ended_at DESC);

CREATE TABLE service.ugc_account (
    user_id text NOT NULL PRIMARY KEY,
    show_authorship boolean
);
