DROP TRIGGER IF EXISTS constraint_feature_id_exists ON eye.feature_to_frame;

DROP TRIGGER IF EXISTS constraint_feature_id_exists ON house.house_number_feature;

DROP TRIGGER IF EXISTS constraint_object_in_photo_feature_id_foreign_key ON signals.object_in_photo;

DROP TRIGGER IF EXISTS constraint_feature_id_exists ON signs_detect.sign_feature;

DROP TRIGGER IF EXISTS constraint_feature_id_exists ON traffic_light.traffic_light_feature;

DROP FUNCTION IF EXISTS check_feature_id_exists();

ALTER TABLE eye.feature_to_frame 
    ADD CONSTRAINT feature_to_frame_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

ALTER TABLE house.house_number_feature 
    ADD CONSTRAINT house_number_feature_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

ALTER TABLE rides.queued_photo_id 
    ADD CONSTRAINT queued_photo_id_photo_id_fkey
    FOREIGN KEY (photo_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

-- feature_id is primary and foreign key at the same time
ALTER TABLE signals.feature_qa_task
    ADD CONSTRAINT feature_qa_task_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

ALTER TABLE signals.feature_transaction
    ADD CONSTRAINT feature_transaction_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

ALTER TABLE signals.object_in_photo
    ADD CONSTRAINT object_in_photo_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

ALTER TABLE signs_detect.sign_feature
    ADD CONSTRAINT sign_feature_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;

ALTER TABLE traffic_light.traffic_light_feature
    ADD CONSTRAINT traffic_light_feature_feature_id_fkey
    FOREIGN KEY (feature_id) 
    REFERENCES signals.feature (feature_id)
    NOT VALID;
