ALTER TABLE signals.walk_object
    DROP CONSTRAINT IF EXISTS walk_object_status_check;

ALTER TABLE signals.walk_object
    ADD CHECK (status = ANY (ARRAY['pending',
                                   'discarded',
                                   'wait_publishing',
                                   'published',
                                   'failed']));

ALTER TABLE signals.walk_object
    DROP CONSTRAINT IF EXISTS walk_object_feedback_type_check;

ALTER TABLE signals.walk_object
    ADD CHECK (feedback_type = ANY(ARRAY['none',
                                'other',
                                'building_entrance',
                                'address_plate',
                                'entrance_plate',
                                'business_sign',
                                'business_working_hours',
                                'foot_path',
                                'cycle_path,',
                                'stairs',
                                'ramp']));

ALTER TABLE signals.walk_object
    ADD COLUMN dataset text,
    ADD COLUMN user_id text,
    ADD COLUMN ugc_account_task_id text,
    ADD COLUMN geometry geometry(Geometry, 3395);
