CREATE TABLE IF NOT EXISTS signals.eye_panorama(
    oid text PRIMARY KEY,
    txn_id bigint NOT NULL,

    date timestamp NOT NULL,
    session_id bigint NOT NULL,
    order_num integer NOT NULL,
    position geometry(Point, 4326) NOT NULL,
    vehicle_course_deg real NOT NULL,

    deleted boolean NOT NULL
);

CREATE INDEX signals_eye_panorama_txn_id_index ON signals.eye_panorama USING btree(txn_id);

COMMENT ON TABLE signals.eye_panorama IS
'http://ecstatic.maps.yandex.net/pkg/yandex-maps-streetview-description/versions';

CREATE TABLE eye.panorama_to_frame(
    oid text NOT NULL REFERENCES signals.eye_panorama (oid),
    frame_id bigint NOT NULL UNIQUE REFERENCES eye.frame (frame_id) ON DELETE CASCADE,

    heading float NOT NULL,
    tilt float NOT NULL,
    hfov float NOT NULL,
    width smallint NOT NULL,
    height smallint NOT NULL,

    UNIQUE(oid, frame_id)
);

CREATE INDEX eye_panorama_to_frame_oid_index ON eye.panorama_to_frame USING btree(oid);

COMMENT ON TABLE eye.panorama_to_frame IS 'one to many panorama <-> frames relation';
