CREATE TABLE eye.detection_relation (
    relation_id bigserial PRIMARY KEY,
    master_detection_id bigint NOT NULL REFERENCES eye.detection (detection_id) ON DELETE CASCADE,
    slave_detection_id bigint NOT NULL REFERENCES eye.detection (detection_id) ON DELETE CASCADE,
    txn_id bigserial NOT NULL,
    deleted boolean NOT NULL
);

CREATE INDEX eye_detection_relation_master_detection_id_index ON eye.detection_relation USING btree(master_detection_id);
CREATE INDEX eye_detection_relation_slave_detection_id_index ON eye.detection_relation USING btree(slave_detection_id);
CREATE INDEX eye_detection_relation_txn_id_index ON eye.detection_relation USING btree(txn_id);

CREATE TABLE eye.object_relation (
    relation_id bigserial PRIMARY KEY,
    master_object_id bigint NOT NULL REFERENCES eye.object (object_id) ON DELETE CASCADE,
    slave_object_id bigint NOT NULL REFERENCES eye.object (object_id) ON DELETE CASCADE,
    txn_id bigserial NOT NULL,
    deleted boolean NOT NULL
);

CREATE INDEX eye_object_relation_master_object_id_index ON eye.object_relation USING btree(master_object_id);
CREATE INDEX eye_object_relation_slave_object_id_index ON eye.object_relation USING btree(slave_object_id);
CREATE INDEX eye_object_relation_txn_id_index ON eye.object_relation USING btree(txn_id);