CREATE TABLE eye.panorama_session_to_device(
    session_id bigint NOT NULL,
    device_id bigint NOT NULL REFERENCES eye.device (device_id) ON DELETE CASCADE,
    deviation real NOT NULL,

    UNIQUE(session_id, deviation)
);

CREATE INDEX eye_panorama_session_id_to_device_session_id_index
    ON eye.panorama_session_to_device USING btree(session_id);

COMMENT ON TABLE eye.panorama_session_to_device IS 'one to many panorama session id <-> devices relation';
