DROP INDEX IF EXISTS signals.assignment_video_assignment_id_idx;

ALTER TABLE signals.assignment_video RENAME TO video;

ALTER TABLE signals.video
    DROP COLUMN assignment_id,
    DROP COLUMN geom,
    ADD COLUMN dataset text,
    ADD COLUMN duration_seconds real NOT NULL;

CREATE TABLE signals.frame_to_video (
    id bigserial PRIMARY KEY,
    frame_id bigint NOT NULL REFERENCES signals.feature (feature_id) ON DELETE CASCADE,
    video_id bigint NOT NULL REFERENCES signals.video (id) ON DELETE CASCADE,
    seconds_from_start real NOT NULL,
    UNIQUE (frame_id, video_id)
);

CREATE INDEX frame_to_video_video_id ON signals.frame_to_video USING btree(video_id);
