CREATE TYPE eye.verification_source AS ENUM (
    'toloka',
    'yang',
    'nmaps'
);

CREATE TABLE eye.verified_detection_pair_match (
    id bigserial PRIMARY KEY,
    source eye.verification_source NOT NULL,
    txn_id bigint NOT NULL,
    first_detection_id bigint NOT NULL REFERENCES eye.detection (detection_id) ON DELETE CASCADE,
    second_detection_id bigint NOT NULL REFERENCES eye.detection (detection_id) ON DELETE CASCADE,
    approved boolean,

    UNIQUE(source, first_detection_id, second_detection_id)
);

CREATE INDEX eye_verified_detection_pair_match_txn_id_index ON eye.verified_detection_pair_match USING btree(txn_id);
CREATE INDEX eye_verified_detection_pair_match_first_detection_id_index ON eye.verified_detection_pair_match USING btree(first_detection_id);
CREATE INDEX eye_verified_detection_pair_match_second_detection_id_index ON eye.verified_detection_pair_match USING btree(second_detection_id);
CREATE INDEX eye_verified_detection_pair_match_approved_index ON eye.verified_detection_pair_match USING btree(approved) WHERE approved IS NULL;


INSERT INTO toloka_mgr.task_type_info (type_id, name)
VALUES (9, 'detection-pair-match');

CREATE TABLE eye.verified_detection_pair_match_to_toloka_task (
    verified_task_id bigint NOT NULL REFERENCES eye.verified_detection_pair_match (id) ON DELETE CASCADE,
    toloka_task_id bigint NOT NULL REFERENCES toloka_mgr.task (id) ON DELETE CASCADE
);

CREATE UNIQUE INDEX eye_verified_detection_pair_match_to_toloka_task_verified_id_index ON eye.verified_detection_pair_match_to_toloka_task USING btree(verified_task_id);
CREATE UNIQUE INDEX eye_verified_detection_pair_match_to_toloka_task_toloka_id_index ON eye.verified_detection_pair_match_to_toloka_task USING btree(toloka_task_id);
