CREATE TABLE eye.verified_detection_missing_on_frame (
    id bigserial PRIMARY KEY,
    source eye.verification_source NOT NULL,
    txn_id bigint NOT NULL,
    detection_id bigint NOT NULL REFERENCES eye.detection (detection_id) ON DELETE CASCADE,
    frame_id bigint NOT NULL REFERENCES eye.frame (frame_id) ON DELETE CASCADE,
    place_is_visible boolean,
    detection_is_hidden boolean,
    detection_is_visible boolean,

    UNIQUE(source, detection_id, frame_id)
);

CREATE INDEX eye_verified_detection_missing_on_frame_txn_id_index ON eye.verified_detection_missing_on_frame USING btree(txn_id);
CREATE INDEX eye_verified_detection_missing_on_frame_detection_id_index ON eye.verified_detection_missing_on_frame USING btree(detection_id);
CREATE INDEX eye_verified_detection_missing_on_frame_frame_id_index ON eye.verified_detection_missing_on_frame USING btree(frame_id);
CREATE INDEX eye_verified_detection_missing_on_frame_detection_is_visible_is_null_index ON eye.verified_detection_missing_on_frame USING btree(detection_is_visible) WHERE detection_is_visible IS NULL;


INSERT INTO toloka_mgr.task_type_info (type_id, name)
VALUES (10, 'detection-missing-on-frame');

CREATE TABLE eye.verified_detection_missing_on_frame_to_toloka_task (
    verified_task_id bigint NOT NULL REFERENCES eye.verified_detection_missing_on_frame (id) ON DELETE CASCADE,
    toloka_task_id bigint NOT NULL REFERENCES toloka_mgr.task (id) ON DELETE CASCADE
);

CREATE UNIQUE INDEX eye_verified_detection_missing_on_frame_to_toloka_task_verified_id_index ON eye.verified_detection_missing_on_frame_to_toloka_task USING btree(verified_task_id);
CREATE UNIQUE INDEX eye_verified_detection_missing_on_frame_to_toloka_task_toloka_id_index ON eye.verified_detection_missing_on_frame_to_toloka_task USING btree(toloka_task_id);
